
#include <png.h>
#include <stdlib.h>

#pragma pack(1)
typedef struct tagBITMAP {
	int				bmType;
	int				bmWidth;
	int				bmHeight;
	int				bmWidthBytes;
	unsigned char	bmPlanes;
	unsigned char	bmBitsPixel;
	void*			bmBits;
} BITMAP;
#pragma pack()

// R8G8B8̏o
int __stdcall PNG_write(char* file, BITMAP* bm) {
	FILE* fp = NULL;
	png_structp png_ptr = NULL;
	png_infop info_ptr = NULL;
	png_color_8 sig_bit;
	int i;
	memset(&sig_bit, 0, sizeof(sig_bit));
	
	png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING,
			NULL, NULL, NULL);
	if(!png_ptr) {
		printf("failed png_create_write_struct.\n");
		goto __error;
	}
	
	info_ptr = png_create_info_struct(png_ptr);
	if(!info_ptr) {
		printf("failed png_create_info_struct.\n");
		goto __error;
	}
	if(setjmp(png_jmpbuf(png_ptr))) {
		printf("failed setjmp.\n");
		goto __error;
	}
	
	fp = fopen(file, "wb");
	if(!fp) {
		printf("failed fopen %s.\n", file);
		goto __error;
	}
	png_init_io(png_ptr, fp);
	png_set_IHDR(png_ptr, info_ptr, bm->bmWidth, bm->bmHeight, 8
			, PNG_COLOR_TYPE_RGB, PNG_INTERLACE_NONE
			, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);
	sig_bit.red = 8;
	sig_bit.green = 8;
	sig_bit.blue = 8;
	
	png_write_info(png_ptr, info_ptr);
	png_set_shift(png_ptr, &sig_bit);
	png_set_bgr(png_ptr);
	png_bytep* row_pointers = malloc(sizeof(png_bytep)*bm->bmHeight);
	
	for(i = 0; i < bm->bmHeight; i++)
		row_pointers[i] = bm->bmBits + (bm->bmHeight-i-1)*bm->bmWidthBytes;
	
	png_write_image(png_ptr, row_pointers);
	png_write_end(png_ptr, info_ptr);
	
	free(row_pointers);
	png_destroy_write_struct(&png_ptr, &info_ptr);
	fclose(fp);
	
	return 0;
__error:
	if(png_ptr) {
		png_destroy_write_struct(&png_ptr, (info_ptr ? &info_ptr : png_infopp_NULL));
	}
	if(fp) {
		fclose(fp);
	}
	return -1;
}
