﻿

private import bitmap;

private import std.stream;
private import std.string;
private import std.math;
private import std.conv;

struct BITMAP {
	align(1):
	int		bmType;
	int		bmWidth;
	int		bmHeight;
	int		bmWidthBytes;
	ubyte	bmPlanes;
	ubyte	bmBitsPixel;
	void*	bmBits;
};

extern(C) int PNG_write(char* file, BITMAP* bm);

int abs(int i) {
	return i < 0 ? -i : i;
}

double toDouble(char[] s) {
	return atof(s);
}

// ボウルの形状 (1990 by T.M)
const double[] BOWL_SHAPE = [
	0.11, 1.32,
	7.79, 1.32,
	8.00, 1.328,
	8.10, 1.332,
	8.20, 1.336,
	8.30, 1.34,
	8.40, 1.346,
	8.50, 1.353,
	8.60, 1.36,
	8.70, 1.3675,
	8.80, 1.357,
	8.90, 1.3825,
	9.00, 1.39,
	9.10, 1.40,
	9.20, 1.41,
	9.30, 1.42,
	9.40, 1.43,
	9.50, 1.45,
	9.60, 1.48,
	9.70, 1.51,
	9.80, 1.54,
	9.90, 1.56,
	10.00, 1.59,
	10.10, 1.62,
	10.20, 1.65,
	10.30, 1.68,
	10.40, 1.72,
	10.50, 1.75,
	10.60, 1.79,
	10.70, 1.82,
	10.80, 1.86,
	10.90, 1.90,
	11.00, 1.94,
	11.10, 1.98,
	11.20, 2.02,
	11.30, 2.06,
	11.40, 2.11,
	11.50, 2.16,
	11.60, 2.22,
	11.70, 2.28,
	11.80, 2.33,
	11.90, 2.39,
	12.00, 2.45,
	12.10, 2.51,
	12.20, 2.58,
	12.30, 2.65,
	12.40, 2.73,
	12.50, 2.80,
	12.60, 2.88,
	12.70, 2.95,
	12.80, 3.03,
	12.90, 3.10,
	13.00, 3.19,
	13.10, 3.28,
	13.20, 3.37,
	13.30, 3.46,
	13.40, 3.56,
	13.50, 3.66,
	13.60, 3.76,
	13.70, 3.87,
	13.80, 3.97,
	13.90, 4.08,
	14.00, 4.19,
	14.10, 4.31,
	14.18, 4.40,
	14.26, 4.50,
	14.34, 4.60,
	14.41, 4.70,
	14.48, 4.80,
	14.55, 4.90,
	14.62, 5.00,
	14.69, 5.10,
	14.76, 5.20,
	14.82, 5.30,
	14.88, 5.40,
	14.95, 5.50,
	15.01, 5.60,
	15.07, 5.70,
	15.13, 5.80,
	15.19, 5.90,
	15.24, 6.00,
	15.30, 6.10,
	15.35, 6.20,
	15.40, 6.30,
	15.45, 6.40,
	15.51, 6.50,
	15.56, 6.60,
	15.61, 6.70,
	15.66, 6.80,
	15.71, 6.90,
	15.76, 7.00,
	15.81, 7.10, 
	15.85, 7.20,
	15.90, 7.30,
	15.94, 7.40,
	15.99, 7.50,
	16.03, 7.60,
	16.07, 7.70,
	16.12, 7.80,
	16.16, 7.90,
	16.20, 8.00,
	16.24, 8.10,
	16.29, 8.20,
	16.33, 8.30,
	16.37, 8.40,
	16.41, 8.50,
	16.45, 8.60,
	16.49, 8.70,
	16.53, 8.80,
	16.57, 8.90,
	16.61, 9.00,
	16.65, 9.10,
	16.68, 9.20,
	16.72, 9.30,
	16.76, 9.40,
	16.79, 9.50,
	16.82, 9.60,
	16.86, 9.70,
	16.89, 9.80,
	16.92, 9.90,
	16.95, 10.0,
	16.98, 10.1,
	17.01, 10.2,
	17.04, 10.3,
	17.07, 10.4,
	17.10, 10.5,
	17.13, 10.6,
	17.16, 10.7,
	17.19, 10.8,
	17.22, 10.9,
	17.25, 11.0,
	17.30, 11.2,
	17.36, 11.4,
	17.41, 11.6,
	17.46, 11.8,
	17.51, 12.0,
	17.56, 12.2,
	17.61, 12.4,
	17.65, 12.6,
	17.70, 12.8,
	17.74, 13.0,
	17.78, 13.2,
	17.82, 13.4,
	17.86, 13.6,
	17.90, 13.8,
	17.94, 14.0,
	17.97, 14.2,
	18.01, 14.4,
	18.04, 14.6,
	18.07, 14.8,
	18.097, 14.98,
	18.10, 15.0,
	18.4, 17.0
];

const double[] RESTORE_711_A3 = [
	180.12220,
	174.02990,
	165.17019,
	152.61694,
	134.68455,
	109.17643,
	 77.71935,
	 48.40163,			// これがボールのてっぺん？？
	 23.29225
];

const double[] RESTORE_711_B3 = [
	158.38534,
	189.48039,
	219.02453,
	246.96613,
	271.91545,
	289.72943,
	295.96098,
	296.00000,
	296.00000
];

const int[] RESTORE_711_H = [
	152,
	135,
	111,
	83,
	58,
	33,
	2,
	1,
	1
];

int main(char[][] argv) {
	if(argv.length < 2) {
		stdout.writeLine("no input file.");
		return 1;
	}
	
	char[] file = argv[1];
	
	// 拡張子手前までを取り出し
	int i = find(file, '.');
	char[] name;
	if(i >= 0) {
		name = file[0 .. i];
	} else {
		name = file;
	}
	
	int stars = 0;
	double[] mg;
	double[] dc;
	double[] ra;
	double[] x;
	double[] y;
	double[] ka;
	int[] po;
	double[] kx, ky;
	int[] kl;
	
	x = new double[154];
	y = new double[154];
	ka = new double[154];
	po = new int[91];
	kx = new double[10];
	ky = new double[10];
	kl = new int[10];
	
	const double DOME = 1500;	// ドームの半径[mm]
	const double BOWLT = 296;	// ボウルの上面の高さ[mm]
	const double LAMP = 180;	// EX球の高さ[mm]
	const double RAD = PI/180.0;
	
	double gs1 = 10;
	double gs2 = 10;
	double gs3 = 25;
	double gs4 = 25;
	double hx = 300;
	double hy = 200;
	double hw = 600;
	double hx1, hy1;
	double gsx, gsy, gx, gy, gx1, gy1;
	double hx2 = 1000;
	double hy2 = 1000;
	
	double dpcm = 100.0; // [解像度] pixel/cm
	
	// ビットマップの設定
	Bitmap bitmap;
	Graphics g;
	
	for(int i = 1, j = 0; i <= 153; i++) {
		x[i] = (BOWL_SHAPE[j++] - 0.1) * 10;
		y[i] = BOWLT - (BOWL_SHAPE[j++] - 1.32) * 10;
		//printf("%d %f %f\n", i, x[i], y[i]);
	}
	
	File input = new File(file);
	stdout.writeLine(format("load data from %s.", file));
	while(!input.eof) {
		char[] line = input.readLine();
		char[] a = line[ 4 .. (4+9)];
		char[] b = line[14 .. (14+9)];
		mg ~= toDouble(line[24 .. (24+4)]);
		double a1 = toDouble(a[0 .. (0+3)]);
		double a2 = toDouble(a[4 .. (4+2)]);
		double a3 = toDouble(a[6 .. (6+2)]);
		ra ~= a1*15+a2/4+a3/240;
		double b1 = toDouble(b[1 .. (1+2)]);
		double b2 = toDouble(b[4 .. (4+2)]);
		double b3 = toDouble(b[6 .. (6+1)]);
		double n = b1+b2/60+b3/600;
		dc ~= b[0] == '-' ? -n : n;
		stdout.writeLine(format("%s[%d] %f %f %f", name, stars, mg[stars], ra[stars], dc[stars]));
		stars++;
	}
	input.close();
	input = null;
	stdout.writeLine(format("+OK %d stars", stars));
	
	stdout.writeLine(format("create bitmap A4. 21.0 cm x 29.7 cm %f dpcm", dpcm));
	bitmap = new Bitmap(Unit.cm, 21.0, 29.7, ResolutionUnit.pixel_cm, dpcm);
	stdout.writeLine(format("+OK %d x %d pixels", bitmap.fPixelWidth, bitmap.fPixelHeight));
	g = new Graphics(bitmap);
	g.setUnit(Unit.pixel);
	
	stdout.writeLine("calc DOME ....");
	
	ka[1] = 1e20;
	for(int i = 2; i <= 153; i++)
		ka[i] = (y[i]-LAMP)/x[i];
	po[0] = 152;
	for(int i = 1; i <= 90; i++) {
		double a = cos(RAD*i)*DOME;
		double b = sin(RAD*i)*DOME;
		double c = (b-LAMP)/a;
		for(int j = po[i-1]; j >= 1; j--) {
			a = ka[j]-c;
			b = ka[j+1]-c;
			if(a*b <= 0.0) {
				po[i] = j;
				j = 0;
			}
		}
	}
	for(int i = 0; i <= 8; i++) {
		int n = i+1;
		kx[n] = RESTORE_711_A3[i];
		ky[n] = RESTORE_711_B3[i];
		kl[n] = RESTORE_711_H[i];
	}
	
	stdout.writeLine("+OK");
	
	while(true) {
		// ファイル名
		g.clear(0xff, 0xff, 0xff);
		
		// 入力受付
		stdout.writeLine("No flip -- 1 Flip -- 2 Quit -- 3");
		int han = toInt(stdin.readLine());
		if(han == 3) break;
		stdout.writeLine("North -- 1 South -- 2");
		int hk = toInt(stdin.readLine());
		stdout.writeLine("IDC(Sekii) = ");
		int idc = toInt(stdin.readLine());		// 赤緯
		stdout.writeLine("IRA(Sekikei) = ");
		int ira = toInt(stdin.readLine());		// 赤経
		
		int ihan = han;
		int ihk = hk;
		int iidc = idc;
		int iira = ira;
		
		int fi = 1; // 赤緯の符号 1が北、-1が南
		if(han == 2) han = -1;
		
		if(hk == 2) {
			idc = -idc;
			fi = -1;
		}
		if(idc < 0) {
			idc = -idc;
			fi = -1;
		}
		idc = idc/10 + 1;
		
		void drawStarA(Graphics g, double x, double y, double mg) {
			g.setPenColor(0, 0, 0);
			g.drawCircle(x, y, 2.0);
		}
		void drawStarB(Graphics g, double x, double y, double mg) {
			if(mg < 1.5) {
				g.setPenColor(0, 0, 0xFF);		// 青 1等星
			} else if(mg < 2.5) {
				g.setPenColor(0, 0xFF, 0);		// 緑 2等星
			} else if(mg < 3.5) {
				g.setPenColor(0xFF, 0, 0);		// 赤 3等星
			} else if(mg < 4.5) {
				g.setPenColor(0xFF, 0xFF, 0);	// 黄 4等星
			} else {
				g.setPenColor(0, 0, 0);			// 黒 5等星
			}
			g.drawCircle(x, y, (mg < 1.5 ? 60.0 : 20.0));
		}
		
		int numStar = 0;
		
		if(abs(idc) <= 6) {
__LINE_830: // プギャーーー
			// 恒星のプロット（赤道から６０度まで）
			int fc = 0; // frame number
			bit fs = false; // find star in the frame ?
			hx1 = hx+fc*hw;
			hy1 = hy;
			gsx = gs1;
			gsy = gs2;
			for(int i = 0; i < 2; i++) {
				fs = false;
				for(int j = 0; j < stars; j++) {
					double a = ra[j];
					double b = dc[j]*fi;
					if((a < ira*15) || (a >= ira*15+15) || (b < idc*10-10) || (b >= idc*10)) {
						continue;
					}
					// j番目の星がフレーム内なら処理
					fs = true;
					double aa = cos(RAD*b)*DOME;
					double ba = sin(RAD*b)*DOME;
					int h = po[cast(int)(b+1)];
					double a3, b3;
					while(true) {
						double a1 = x[h];
						double a2 = x[h+1];
						double b1 = y[h];
						double b2 = y[h+1];
						double c = (LAMP*(a1-a2)+b1*a2-a1*b2)/((LAMP-ba)*(a1-a2)+aa*(b1-b2));
						a3 = c*aa;
						b3 = c*(ba-LAMP)+LAMP;
						if((b1-b3)*(b2-b3) > 0.0) {
							stdout.writeLine("trap at 1040");
							stdout.writeLine(format("b=%f h=%d", b, h));
							h++;
							if(h >= 153) {
								stdout.writeLine("error!");
								return 0;
							}
						} else {
							break;
						}
					}
					int h1 = kl[idc];
					double gh = 0;
					a = kx[idc];
					b = ky[idc];
					// この一行で直るか？
					if(h1 != h) {
						do {
							double c1 = sqrt((a-x[h1])*(a-x[h1])+(b-y[h1])*(b-y[h1]));
							gh = gh-c1;
							a = x[h1];
							b = y[h1];
							h1--;
						} while (h1 > h);
					}
					double c1 = sqrt((a-a3)*(a-a3)+(b-b3)*(b-b3));
					gh = gh-c1;
					double c = (ra[j]-(cast(int)(ra[j]/15))*15)/15;
					double c2 = PI*a3/24;
					c = han*fi*(c2-2.0*c2*c);
					gx = c;
					gy = gh;
					if(i == 0) {
						drawStarA(g, hx1+gx*gsx, hy1-gy*gsy, mg[j]);
					} else {
						drawStarB(g, hx1+gx*gsx, hy1-gy*gsy, mg[j]);
						numStar++;
					}
				}
				
				if(i == 0) {
					if(fs) {
						// ☆が存在すればフレーム作図
						// gosub *frame
						// inline プギャー
						double a, b, c;
						a = PI*kx[idc]/24;
						gx = -a;
						gy = 0;
						gx1 = a;
						gy1 = 0;
						// gosub *glinexyp
						g.drawLine(hx1+gx*gsx, hy1-gy*gsy, hx1+gx1*gsx, hy1-gy1*gsy);
						double a1 = a;
						double gh = 0;
						int h = kl[idc];
						a = kx[idc];
						b = ky[idc];
						
						do {
							c = PI*x[h]/24;
							double c1 = sqrt((a-x[h])*(a-x[h]) + (b-y[h])*(b-y[h]));
							gh = gh - c1;
							gx = -a1;
							gy = gh + c1;
							gx1 = -c;
							gy1 = gh;
							// gosub *glinexyp
							g.drawLine(hx1+gx*gsx, hy1-gy*gsy, hx1+gx1*gsx, hy1-gy1*gsy);
							a1 = c;
							a = x[h];
							b = y[h];
							h--;
						} while(h > kl[idc+1]);
						
						
						a1 = PI*kx[idc]/24;
						gh = 0;
						h = kl[idc];
						a = kx[idc];
						b = ky[idc];
						
						do {
							c = PI*x[h]/24;
							double c1 = sqrt((a-x[h])*(a-x[h]) + (b-y[h])*(b-y[h]));
							gh = gh-c1;
							gx = a1;
							gy = gh + c1;
							gx1 = c;
							gy1 = gh;
							// gosub *glinexyp
							g.drawLine(hx1+gx*gsx, hy1-gy*gsy, hx1+gx1*gsx, hy1-gy1*gsy);
							a1 = c;
							a = x[h];
							b = y[h];
							h--;
						} while(h > kl[idc+1]);
						
						c = PI*kx[idc+1]/24;
						double c1 = sqrt((a-kx[idc+1])*(a-kx[idc+1]) + (b-ky[idc+1])*(b-ky[idc+1]));
						gh = gh-c1;
						
						gx = -c;
						gy = gh;
						gx1 = -a1;
						gy1 = gh+c1;
						g.drawLine(hx1+gx*gsx, hy1-gy*gsy, hx1+gx1*gsx, hy1-gy1*gsy);
						
						gx = c;
						gx1 = a1;
						g.drawLine(hx1+gx*gsx, hy1-gy*gsy, hx1+gx1*gsx, hy1-gy1*gsy);
						
						gx1 = -c;
						gy1 = gh;
						g.drawLine(hx1+gx*gsx, hy1-gy*gsy, hx1+gx1*gsx, hy1-gy1*gsy);
						// gosub *cpxyp
						
						fc++;
					}
				}
			}
			if(fc >= 4) {
				stdout.writeLine("Frame Over !");
			}
			ira++;
			if(ira < 24) {
				goto __LINE_830; // プギャーーーーーーー
			} else {
			}
		} else {
			// 北天、南天のフレーム作図
			hx1 = hx2;
			hy1 = hy2;
			gsx = gs3/2.5;
			gsy = gs4/2.5;
			
			// 円を描き,中心を通る線で１２分割
			g.drawCircle(hx1, hy1, kx[7]*gsx);
			g.drawCircle(hx1, hy1, kx[8]*gsx);
			g.drawCircle(hx1, hy1, kx[9]*gsx);
			
			for(int i = 0; i < 12 ; i++) {
				gx = kx[7]*cos(PI*i/12);
				gy = kx[7]*sin(PI*i/12);
				g.drawLine(hx1-(gx*gsx), hy1-(gy*gsy), hx1+(gx*gsx), hy1+(gy*gsy));
			}
			
			// 北天、南天の星のプロット
			for(int i = 0; i < 2; i++) {
				for(int j = 0; j < stars; j++) {
					double a = ra[j];
					double b = dc[j] * fi;
					if(b >= 60.0) {
						double aa = cos(RAD*b)*DOME;
						double ba = sin(RAD*b)*DOME;
						int h = po[cast(int)(b+1)];
						double a3;
						while(true) {
							double a1 = x[h];
							double a2 = y[h+1];
							double b1 = y[h];
							double b2 = y[h+1];
							double c = (LAMP*(a1-a2)+b1*a2-a1*b2)/((LAMP-ba)*(a1-a2)+aa*(b1-b2));
							a3 = c*aa;
							double b3 = c*(ba-LAMP)+LAMP;
							if((b1-b3)*(b2-b3) > 0.0) {
								h++;
								if(h >= 153) {
									stdout.writeLine("error!");
									return 0;
								}
							} else {
								break;
							}
						}
						gx = a3*cos(RAD*a*-fi);
						gy = a3*sin(RAD*a*-fi)*-han;
						if(i == 0) {
							drawStarA(g, hx1+gx*gsx, hy1-gy*gsy, mg[j]);
						} else {
							drawStarB(g, hx1+gx*gsx, hy1-gy*gsy, mg[j]);
							numStar++;
						}
					}
				}
			}
		}
		if(numStar == 0) {
			stdout.writeLine("nostar.");
		} else {
			
			char ns = (hk == 1 ? 'N' : 'S');
			char[] fn = format("%s_idc%d_ira%d_", name, iidc, iira);
			fn ~= ns;
			if(han == 2) {
				fn ~= "_flip";
			}
			//fn ~= ".bmp";
			fn ~= ".png";
			stdout.writeLine(format("found %d stars.", numStar));
			stdout.writeLine(format("save to %s.", fn));
			// bitmap.saveFile(fn);
			BITMAP bm;
			bm.bmWidthBytes = bitmap.fPitch;
			bm.bmWidth = bitmap.fPixelWidth;
			bm.bmHeight = bitmap.fPixelHeight;
			bm.bmBits = bitmap.fPixels;
			bm.bmBitsPixel = bitmap.fBitsPerPixel;
			PNG_write(toStringz(fn), &bm);
		}
	}
	return 1;
}

enum Unit {
	pixel = 0,
	inch,
	cm,
	mm,
};

enum ResolutionUnit {
	pixel_inch,
	pixel_cm,
};

// R8G8B8 Bitmap
class Bitmap {
private:
	Unit fUnit;
	double fWidth;
	double fHeight;
	ResolutionUnit fResolutionUnit;
	double fResolution;
	
	ushort fPixelWidth;
	ushort fPixelHeight;
	ushort fBitsPerPixel;
	ushort fBytesPerPixel;
	uint fPitch;
	
	static const double inch2cm = 2.5402201524132; // cm/inch
	static const double cm2mm = 10.0; // cm/mm = 10.0
	
	ubyte[] fPixels;
public:
	static int toPixel(Unit unit, ResolutionUnit resolutionUnit, double resolution, double num) {
		switch(unit) {
		case Unit.pixel:
			return cast(int)num;
		case Unit.inch:
			switch(resolutionUnit) {
			case ResolutionUnit.pixel_inch:
				return cast(int)(num*resolution);
			case ResolutionUnit.pixel_cm:
				return cast(int)(num*resolution*inch2cm);
			}
			break;
		case Unit.cm:
			switch(resolutionUnit) {
			case ResolutionUnit.pixel_inch:
				return cast(int)(num*resolution/inch2cm);
			case ResolutionUnit.pixel_cm:
				return cast(int)(num*resolution);
			}
			break;
		case Unit.mm:
			switch(resolutionUnit) {
			case ResolutionUnit.pixel_inch:
				return cast(int)(num*resolution/cm2mm/inch2cm);
			case ResolutionUnit.pixel_cm:
				return cast(int)(num*resolution/cm2mm);
			}
			break;
		}
	}
	this(Unit unit, double width, double height, ResolutionUnit resolutionUnit, double resolution) {
		fUnit = unit;
		fWidth = width;
		fHeight = height;
		fResolutionUnit = resolutionUnit;
		fResolution = resolution;
		
		fPixelWidth = toPixel(unit, resolutionUnit, resolution, width);
		fPixelHeight = toPixel(unit, resolutionUnit, resolution, height);
		
		fBitsPerPixel = 24;
		fBytesPerPixel = 3;
		fPitch = (cast(uint)fBytesPerPixel*fPixelWidth*4+3)/4;
		fPixels = new ubyte[cast(size_t)fPitch*fPixelHeight];
	}
	// 単位はピクセル
	void setPixel(uint c, int x, int y) {
		if(x < 0 || y < 0 || x >= fPixelWidth || y >= fPixelHeight) return;
		int p = fPitch*(fPixelHeight-1-y) + x*fBytesPerPixel;
		ubyte b = (c >> 16) & 0xFF;
		ubyte g = (c >> 8) & 0xFF;
		ubyte r = c & 0xFF;
		fPixels[p] = b;
		fPixels[p+1] = g;
		fPixels[p+2] = r;
	}
	uint getPixel(int x, int y) {
		if(x < 0 || y < 0 || x >= fPixelWidth || y >= fPixelHeight) return 0;
		size_t p = fPitch*y + x*fBytesPerPixel;
		return makeColor(fPixels[p], fPixels[p+1], fPixels[p+2]);
	}
	
	uint makeColor(ubyte r, ubyte g, ubyte b) {
		return (cast(uint)b << 16) | (cast(uint)g << 8) | cast(uint)r;
	}
	
	void saveFile(char[] file) {
		BitmapFileHeader bfh;
		BitmapInfoHeader bih;
		
		bfh.bfType = cast(ushort)'B' | (cast(ushort)'M' << 8);
		bfh.bfOffBits = bfh.sizeof + bih.sizeof;
		bfh.bfSize = bfh.bfOffBits + fPitch*fPixelHeight;
		
		uint ppm;
		
		switch(fResolutionUnit) {
		case ResolutionUnit.pixel_inch:
			ppm = cast(uint)(fResolution/inch2cm*100.0);
			break;
		case ResolutionUnit.pixel_cm:
			ppm = cast(uint)(fResolution*100.0);
			break;
		}
		
		bih.biSize = bih.sizeof;
		bih.biWidth = fPixelWidth;
		bih.biHeight = fPixelHeight;
		bih.biPlanes = 1;
		bih.biBitCount = fBitsPerPixel;
		bih.biCompression = 0;
		bih.biSizeImage = fPitch*fPixelHeight;
		bih.biXPelsPerMeter = ppm;
		bih.biYPelsPerMeter = ppm;
		bih.biClrUsed = 0;
		bih.biClrImportant = 0;
		
		File f;
		try {
			f = new File(file, FileMode.Out);
			f.writeBlock(&bfh, bfh.sizeof);
			f.writeBlock(&bih, bih.sizeof);
			f.writeBlock(fPixels, fPixels.length);
		} catch(Exception e) {
			throw e;
		} finally {
			if(f) {
				f.close();
				f = null;
			}
		}
	}
};

class Point {
public:
	double x;
	double y;
	
	this(double x_, double y_) {
		x = x_;
		y = y_;
	}
};

class Graphics {
private:
	Point fAxis;
	uint fPenColor;
	Bitmap fBitmap;
	Unit fUnit;
	
	// ピクセル単位での描画
	// クリップしてない
	void __drawLine(int x1, int y1, int x2, int y2) {
		
		Bitmap bm = fBitmap; 
		uint color = fPenColor;
		
		// クリップ領域の算出
		int left = 0;
		int right = fBitmap.fPixelWidth-1;
		int top = 0;
		int bottom = fBitmap.fPixelHeight-1;
		
		// クリップ処理
		if(x1 < left && x2 < left) return;
		if(x1 > right && x2 > right) return;
		if(y1 < top && y2 < top) return;
		if(y1 > bottom && y2 > bottom) return;
		
		// 未定義
		
		int dx = x2-x1;
		int dy = y2-y1;
		int sx = (dx >= 0) ? 1 : -1;
		int sy = (dy >= 0) ? 1 : -1;
		
		dx = sx*dx+1;
		dy = sy*dy+1;
		
		int xx = x1;
		int yy = y1;
		if(dx < dy) {
			
			for(int x= 0, y = 0; y < dy; y++, yy+=sy) {
				bm.setPixel(color, xx, yy);
				x += dx;
				if(x >= dy) {
					x -= dy;
					xx+=sx;
				}
			}
		} else {
			
			for(int x = 0, y = 0; x < dx; x++, xx+=sx) {
				bm.setPixel(color, xx, yy);
				y += dy;
				if(y >= dx) {
					y -= dx;
					yy+=sy;
				}
			}
		}
	}
	void __drawCircle(int x, int y, int r) {
		
		uint color = fPenColor;
		Bitmap bm = fBitmap;
		
		// クリップ領域の算出
		int left = 0;
		int right = fBitmap.fPixelWidth-1;
		int top = 0;
		int bottom = fBitmap.fPixelHeight-1;
		
		int x1 = x-r;
		int x2 = x+r;
		int y1 = y-r;
		int y2 = y+r;
		
		if(x1<left && x2 < left) return;
		if(x1>right && x2 > right) return;
		if(y1<top && y2 < top) return;
		if(y1>bottom && y2>bottom) return;
		
		//stdout.writeLine(format("__drawCircle(%d, %d, %d) %d", x, y, r, color));
		
		int cx = 0;
		int cy = r;
		int ocx = -1;
		int ocy = -1;
		int df = 1-r;
		int d_e = 3;
		int d_se = -2*r + 5;
		int xpcx, xmcx, xpcy, xmcy;
		int ypcy, ymcy, ypcx, ymcx;
		
		do {
			if(ocy != cy || ocx != cx) {
				xpcx = x + cx;
				xmcx = x - cx;
				if(cy > 0) {
					ypcy = y + cy;
					ymcy = y - cy;
					bm.setPixel(color, xmcx, ypcy);
					bm.setPixel(color, xpcx, ypcy);
					bm.setPixel(color, xmcx, ymcy);
					bm.setPixel(color, xpcx, ymcy);
				} else {
					bm.setPixel(color, xmcx, y);
					bm.setPixel(color, xpcx, y);
				}
				ocy = cy;
				xpcy = x + cy;
				xmcy = x - cy;
				if (cx > 0) {
					ypcx = y + cx;
					ymcx = y - cx;
					bm.setPixel(color, xmcy, ypcx);
					bm.setPixel(color, xpcy, ypcx);
					bm.setPixel(color, xmcy, ymcx);
					bm.setPixel(color, xpcy, ymcx);
				} else {
					bm.setPixel(color, xmcy, y);
					bm.setPixel(color, xpcy, y);
				}
				ocx = cx;
			}
			if(df<0) {
				df += d_e;
				d_e += 2;
				d_se += 2;
			} else {
				df += d_se;
				d_e += 2;
				d_se += 4;
				cy--;
			}
			cx++;
		} while(cx<=cy);
	}
	int fPenSize;
public:
	this(Bitmap bitmap) {
		fBitmap = bitmap;
		fAxis = new Point(0.0, 0.0);
		setPenColor(0, 0, 0);
		setUnit(bitmap.fUnit);
		fPenSize = 1;
	}
	void setUnit(Unit unit) {
		fUnit = unit;
	}
	void setAxis(double x, double y) {
		fAxis = new Point(x, y);
	}
	void setPenColor(ubyte r, ubyte g, ubyte b) {
		fPenColor = fBitmap.makeColor(r, g, b);
	}
	void setPenSize(int s) {
		fPenSize = s;
	}
	
	void drawLine(double x1, double y1, double x2, double y2) {
		//stdout.writeLine(format("drawLine(%f, %f, %f, %f)", x1, y1, x2, y2));
		int _x1, _y1, _x2, _y2;
		_x1 = Bitmap.toPixel(fUnit, fBitmap.fResolutionUnit, fBitmap.fResolution, x1);
		_y1 = Bitmap.toPixel(fUnit, fBitmap.fResolutionUnit, fBitmap.fResolution, y1);
		_x2 = Bitmap.toPixel(fUnit, fBitmap.fResolutionUnit, fBitmap.fResolution, x2);
		_y2 = Bitmap.toPixel(fUnit, fBitmap.fResolutionUnit, fBitmap.fResolution, y2);
		
		for(int i = 0; i < fPenSize; i++) {
			int j = (i+1)/2;
			j = i & 1 ? -j : j;
			__drawLine(_x1+j, _y1+j, _x2+j, _y2+j);
		}
		//stdout.writeLine("+OK");
	}
	void drawCircle(double x, double y, double r) {
		//stdout.writeLine(format("drawCircle(%f, %f, %f)", x, y, r));
		int _x, _y, _r;
		_x = Bitmap.toPixel(fUnit, fBitmap.fResolutionUnit, fBitmap.fResolution, x);
		_y = Bitmap.toPixel(fUnit, fBitmap.fResolutionUnit, fBitmap.fResolution, y);
		_r = Bitmap.toPixel(fUnit, fBitmap.fResolutionUnit, fBitmap.fResolution, r);
		for(int i = 0; i < fPenSize; i++) {
			int j = (i+1)/2;
			j = i & 1 ? -j : j;
			__drawCircle(_x, _y, _r+j);
		}
		//stdout.writeLine("+OK");
	}
	void clear(ubyte r, ubyte g, ubyte b) {
		uint col = fBitmap.makeColor(r, g, b);
		for(int i = 0; i < fBitmap.fPixelHeight; i++)
		for(int j = 0; j < fBitmap.fPixelWidth; j++)
			fBitmap.setPixel(col, j, i);
	}
};
